#include <iostream>
#include <fstream>
#include <cmath>
#include <vector>
#include <iomanip>

double PHI = (1.0 + sqrt(5.0)) / 2.0;
double LOG10_PHI = log10(PHI);
double LOG10_SQRT5 = log10(sqrt(5.0));

int getFirstDigitExact(long long n) {

            long long f1 = 1;
            long long f2 = 1;
            if (n <= 2) return 1;
            n -= 2;
            while (n != 0){
                long long temp = f1;
                f1 = f2;
                f2 = temp + f2;
                n--;
            }
            
            long long fibInt = f2;
            
            // Extract first digit
            while (fibInt >= 10) {
                fibInt /= 10;
            }
            return fibInt;
    }

    // Get first digit using logarithmic approximation
int getFirstDigit(long long n) {
        if (n <= 1) return n;
        if (n <= 90) {
            return getFirstDigitExact(n);
        }
        double logFib = n * LOG10_PHI - LOG10_SQRT5;
        double fractionalPart = logFib - std::floor(logFib);
        double firstDigits = std::pow(10.0, fractionalPart);
        
        return static_cast<int>(firstDigits);
    }
    
    // Calculate expected Benford distribution
std::vector<double> benfordDistribution() {
        std::vector<double> dist(10, 0.0);
        for (int d = 1; d <= 9; d++) {
            dist[d] = std::log10(1.0 + 1.0 / d);
        }
        return dist;
    }
    
    // Analyze first digit distribution for Fibonacci sequence
void analyzeBenford(long long max_n) {
        int totalCount = 0;
        std::vector<int> digitCount(10, 0); // 0-9, but we only use 1-9
        for (long long n = 1; n <= max_n; n += 1) {
            int firstDigit = getFirstDigit(n);
            if (firstDigit >= 1 && firstDigit <= 9) {
                digitCount[firstDigit]++;
                totalCount++;
            }
        }
        // Print results
        std::cout << max_n << "\n";
        std::cout << std::fixed << std::setprecision(2);

        
        for (int d = 1; d <= 9; d++) {
            int digitSum = digitCount[d];

            double actualPercent = (digitCount[d] * 100.0) / totalCount;
            
            
            std::cout << std::setw(4) << d << " |"
                 << std::setw(10) << digitSum << " |"
                 << std::setw(9) << actualPercent;
            std::cout << std::endl;
        }
    }
    
int main() {
    int n;
    bool cont = false;
	while (std::cin >> n) {
        if (cont)
            std::cout << std::endl;
        analyzeBenford(n);
        cont = true;
    }
    return 0;
}
